/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef AGTPCIPORT_H
#define AGTPCIPORT_H

// the pre-processor define CHANGE_LONG_TO_INT will change
// longs to int. This define is not taken into account for
// WIN32 builds.
#ifndef WIN32

#ifdef CHANGE_LONG_TO_INT
typedef int IntOrLongType;
typedef unsigned int UIntOrLongType;
#else
typedef long IntOrLongType;
typedef unsigned long UIntOrLongType;
#endif

#else // #ifndef WIN32

typedef long IntOrLongType;
typedef unsigned long UIntOrLongType;

#endif // #ifndef WIN32

typedef UIntOrLongType UInt32;  ///< Unsigned 32 bit integer
typedef unsigned short UInt16;  ///< Unsigned 16 bit integer
typedef unsigned char  UInt8;   ///< Unsigned 8 bit integer

typedef IntOrLongType  Int32;   ///< Signed 32 bit integer
typedef short Int16;            ///< Signed 16 bit integer
typedef char  Int8;             ///< Signed 8 bit integer

typedef UIntOrLongType AgtPortHandleT; ///< Type for all port handles
typedef UIntOrLongType AgtValueT;      ///< Basic type for all numerical property values (usually the value to be set/get)
typedef UIntOrLongType AgtSizeT;       ///< Basic type for all sizes, indices, lines, offsets and addresses 

#ifdef WIN32

// ******************************************************************
// **** WIN32 START
// ******************************************************************

#define WIN32_LEAN_AND_MEAN   // Exclude rarely-used stuff from Windows headers
#include <windows.h>

#ifdef AGTPCIPORT_EXPORTS
// Generating AgtPCIPort.dll:
// Exerciser functions will be declared as exported
#define AGTPCIPORT_API __declspec(dllexport)
#else
// Using AgtPCIPort.dll:
// Exerciser functions will be imported from AgtPCIPort.dll to customer's executable
#define AGTPCIPORT_API __declspec(dllimport)
#endif

// ******************************************************************
// **** WIN32 END
// ******************************************************************

#else

// ******************************************************************
// **** LINUX START
// ******************************************************************

#define AGTPCIPORT_API

typedef IntOrLongType HRESULT;
typedef int HANDLE;

// ******************************************************************
// **** LINUX END
// ******************************************************************

#endif

#define AGT_INVALID_DEVID       0xffff
#define AGT_INVALID_OSHANDLE    ( ( HANDLE ) 0 )
#define AGT_INVALID_PORTHANDLE  0

#include "AgtError.h"

#endif